Imports Microsoft.VisualBasic

Public Class Config
    ''' <summary>
    ''' acuch inicjujcy poczenie, pochodzcy z pliku web.config
    ''' </summary>
    Public Shared ReadOnly Property ConnectionString() As String
        Get
            Return ConfigurationManager.ConnectionStrings( _
                "ConnectionString").ConnectionString
        End Get
    End Property
    ''' <summary>
    ''' Biecy motyw witryny, zdefiniowany w pliku web.config 
    ''' </summary>
    Public Shared ReadOnly Property CurrentTheme() As String
        Get
            Return ConfigurationManager.AppSettings("CurrentTheme").ToString()
        End Get
    End Property
    ''' <summary>
    ''' Kod HTML okrelajcy tytu kadej strony, pochodzcy z pliku 
    ''' web.config
    ''' </summary>
    Public Shared ReadOnly Property PageTitle() As String
        Get
            Return ConfigurationManager.AppSettings("PageTitle").ToString()
        End Get
    End Property

    ''' <summary>
    ''' Liczba okrelajca z ilu godzin wstecz
    ''' maj by wywietlane wiadomoci w kadym pokoju rozmw. 
    ''' Warto ta pochodzi z pliku web.config.
    ''' </summary>
    Public Shared ReadOnly Property HoursToShow() As String
        Get
            Return ConfigurationManager.AppSettings("HoursToShow").ToString()
        End Get
    End Property

    ''' <summary>
    ''' Godzina otwarcia rano
    ''' </summary>
    Public Shared ReadOnly Property HourOpen() As String
        Get
            Return ConfigurationManager.AppSettings("HourOpen").ToString()
        End Get
    End Property
    ''' <summary>
    ''' Godzina zamknicia wieczorem
    ''' </summary>
    Public Shared ReadOnly Property HourClose() As String
        Get
            Return ConfigurationManager.AppSettings("HourClose").ToString()
        End Get
    End Property
    ''' <summary>
    ''' Adres e-mail administratora
    ''' </summary>
    Public Shared ReadOnly Property AdminEmail() As String
        Get
            Return ConfigurationManager.AppSettings("AdminEmail").ToString()
        End Get
    End Property
    ''' <summary>
    ''' Wiadomo wysyana na konto uytkownika 
    ''' </summary>
    Public Shared ReadOnly Property ClosedMessage() As String
        Get
            Return ConfigurationManager.AppSettings("ClosedMessage").ToString()
        End Get
    End Property
    End Class
